//=============================================================================
// ColaBottle.
//=============================================================================
class ColaBottle extends DeusExPickup;

var() int MinDamageToBreak;

#exec TEXTURE IMPORT NAME="ColaBottle" FILE="C:\DeusEx\MarkistanCity\Textures\ColaBottle.pcx" GROUP=Skins

function TakeDamage(int Damage, Pawn EventInstigator, Vector HitLocation, Vector Momentum, name DamageType)
{
 if ((Damage >= MinDamageToBreak) && (RespawnTime == 0))
  BreakItSmashIt(fragType, (CollisionRadius + CollisionHeight) / 2);
}

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
		{
			player.healPlayer(40, False);
		}
		PlaySound(sound'MaleBurp');
		UseOnce();
	}
Begin:
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

defaultproperties
{
     bBreakable=False
     bBlockPlayers=True
     bBlockActors=True
     bCollideActors=True
     bProjTarget=True
     maxCopies=6
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Cola"
     ItemArticle="some"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Liquor40oz'
     PickupViewMesh=LodMesh'DeusExItems.Liquor40oz'
     ThirdPersonMesh=LodMesh'DeusExItems.Liquor40oz'
     LandSound=Sound'DeusExSounds.Generic.GlassHit1'
     Icon=Texture'DeusExUI.Icons.BeltIconBeerBottle'
     largeIcon=Texture'DeusExUI.Icons.LargeIconBeerBottle'
     Skin=Texture'ColaBottle'
     largeIconWidth=20
     largeIconHeight=48
     Description="Cola, looks good too. Made by Commune Farms Inc."
     beltDescription="COLA"
     Mesh=LodMesh'DeusExItems.Liquor40oz'
     CollisionRadius=4.620000
     CollisionHeight=12.500000
     Mass=10.000000
     Buoyancy=8.000000
     MinDamageToBreak=5
}
